<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Select Dates</title>
    <style>
        body { 
            font-family: Arial; 
            padding: 30px; 
            background: #f5f5f5; 
        }

        .date-box {
            display: inline-block;
            padding: 10px 15px;
            background: #e7e7e7;
            border-radius: 6px;
            margin: 5px;
            cursor: pointer;
            user-select: none;
        }

        .date-box.selected {
            background: #4CAF50;
            color: white;
        }

        #result {
            margin-top: 20px;
            padding: 10px;
            background: #e9ffe6;
            border: 1px solid #a7ddb2;
            border-radius: 5px;
            min-height: 20px;
        }
    </style>
</head>
<body>

<h3>Select Dates</h3>

<!-- Date buttons -->
<div id="dateList">
    <div class="date-box">10-01-2025</div>
    <div class="date-box">11-01-2025</div>
	<div class="date-box">12-01-2025</div>
	<div class="date-box">12-01-2025</div>
	<div class="date-box">14-01-2025</div>
</div>

<h3>Selected Dates</h3>
<div id="result1"></div>
<input name="result2" type="text" id="result2">
<script>
let selected = [];

document.querySelectorAll(".date-box").forEach(box => {
    box.addEventListener("click", function () {
        let date = this.textContent.trim();

        // Toggle state
        if (selected.includes(date)) {
            selected = selected.filter(d => d !== date);
            this.classList.remove("selected");
        } else {
            selected.push(date);
            this.classList.add("selected");
        }

        document.getElementById("result1").innerHTML = selected.join("<br>");
		document.getElementById("result2").value = selected.join(",");
    });
});
</script>

</body>
</html>
