<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Search Bookings by Date</title>
    <style>
        body { font-family: Arial, sans-serif; padding: 20px; }
        input { padding: 8px; width: 200px; }
        #results { margin-top: 20px; border: 1px solid #ccc; padding: 10px; }
        .booking { border-bottom: 1px solid #ddd; padding: 5px 0; }
    </style>
</head>
<body>

<h2>Search Bookings by Date</h2>
<input type="date" id="booking_date" placeholder="Select Date" onkeyup="searchBookings()" onchange="searchBookings()">

<div id="results"></div>

<script>
function searchBookings() {
    let date = document.getElementById('booking_date').value;
    if(date === '') {
        document.getElementById('results').innerHTML = '';
        return;
    }

    fetch('search_bookings.php?date=' + encodeURIComponent(date))
        .then(response => response.json())
        .then(data => {
            let html = '';
            if(data.length > 0){
                data.forEach(booking => {
                    html += `<div class="booking">
                        <strong>Room:</strong> ${booking.room_no}<br>
                        <strong>Customer:</strong> ${booking.customer_name}<br>
                        <strong>Check-In:</strong> ${booking.check_in}<br>
                        <strong>Check-Out:</strong> ${booking.check_out}<br>
                        <strong>Status:</strong> ${booking.status}<br>
                    </div>`;
                });
            } else {
                html = 'No bookings found for this date.';
            }
            document.getElementById('results').innerHTML = html;
        })
        .catch(err => console.error(err));
}
</script>

</body>
</html>
