<?php
if (isset($_GET['ip']) && $_GET['ip'] != '') {

    $user_ip = trim($_GET['ip']);

    // Validate IP
    if (!filter_var($user_ip, FILTER_VALIDATE_IP)) {
        echo "Invalid IP address";
        exit;
    }

    $api_url = "http://ip-api.com/json/" . urlencode($user_ip); // Use http for PHP 5.6 SSL issues

    // Initialize cURL
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $api_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);

    $response = curl_exec($ch);

    if ($response === false) {
        echo "API connection failed: " . curl_error($ch);
        curl_close($ch);
        exit;
    }

    curl_close($ch);

    $location = json_decode($response);

    if ($location && $location->status === 'success') {
        echo "IP: " . $user_ip . "<br>";
        echo "Country: " . $location->country . "<br>";
        echo "City: " . $location->city . "<br>";
        echo "ZIP: " . $location->zip . "<br>";
        echo "ISP: " . $location->isp;
    } else {
        echo "Location not found for this IP";
    }

} else {
    echo "IP parameter missing";
}
?><br />
<br />

Time : <?php echo $_GET[time]; ?>