<?php session_start(); ob_start();

include("config2.php");

if (!$conn) { die("Connection failed: " . mysqli_connect_error()); }

// Get userid from query string
$userid = isset($_GET['userid']) ? $_GET['userid'] : '';
if ($userid == '') { die("No user specified."); }

// Fetch existing user permissions
$sql = "SELECT * FROM user WHERE userid='$userid'";
$result = mysqli_query($conn, $sql);
if (!$result || mysqli_num_rows($result) == 0) { die("User not found."); }

$row = mysqli_fetch_assoc($result);
$existing_permissions = explode(',', $row['permissions']);

// Helper to check if permission exists
function is_checked($perm, $existing_permissions) {
    return in_array($perm, $existing_permissions) ? 'checked' : '';
}

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $password = isset($_POST['password']) ? trim($_POST['password']) : '';
    $permissions = array();
    foreach ($_POST as $key => $value) {
        if ($key != 'userid' && $key != 'password') { $permissions[] = $key; }
    }
    $permissions_str = implode(',', $permissions);

    if ($password != '') { $pass_hash = md5($password); } else { $pass_hash = $row['password']; }

    $sql_update = "UPDATE user SET password='$pass_hash', permissions='$permissions_str' WHERE userid='$userid'";
    $res = mysqli_query($conn, $sql_update);
    if ($res) { echo "<p style='color:green; text-align:center;'>Permissions updated successfully.</p>"; $existing_permissions = $permissions; 
			  
header("location:admin_user.php");
			 exit();
			  }
    else { echo "<p style='color:red; text-align:center;'>Error: " . mysqli_error($conn) . "</p>"; }
}

mysqli_close($conn);
?>

<!DOCTYPE html>

<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Edit User Permissions</title>
<style>
body { font-family: Arial, sans-serif; background: #f4f6f9; margin:0; padding:20px; }
.permission-container { max-width: 1000px; margin:0 auto; background:#fff; padding:20px; border-radius:8px; box-shadow:0 3px 6px rgba(0,0,0,0.05); }
.permission-title { font-size:28px; font-weight:bold; margin-bottom:25px; text-align:center; color:#222; }
.login-fields { background:#fefefe; padding:15px; border-radius:8px; margin-bottom:20px; box-shadow:0 2px 4px rgba(0,0,0,0.05); }
.login-fields input { width:100%; padding:10px; margin-bottom:15px; border-radius:6px; border:1px solid #ccc; font-size:16px; }
.login-fields label { font-weight:600; margin-bottom:5px; display:block; }
.menun { list-style:none; padding:0; margin:0; }
.menun li { background:#fff; border-radius:8px; margin-bottom:12px; box-shadow:0 2px 4px rgba(0,0,0,0.05); }
.menun .parent-label { display:flex; align-items:center; cursor:pointer; padding:12px 20px; font-weight:600; font-size:18px; color:#222; }
.menun .parent-label input[type=checkbox] { margin-right:10px; transform:scale(1.2); }
.child-menu { list-style:none; padding-left:30px; display:none; padding-bottom:10px; }
.child-menu li { padding:8px 0; font-size:16px; display:flex; align-items:center; }
.child-menu li input[type=checkbox] { margin-right:10px; transform:scale(1.1); }
.toggle-icon { margin-left:auto; transition:transform 0.3s; font-weight:bold; color:#555; }
.parent.open .toggle-icon { transform:rotate(90deg); }
input[type=submit] { background:#28a745; color:#fff; padding:12px 25px; font-size:18px; font-weight:bold; border:none; border-radius:8px; cursor:pointer; margin-top:15px; }
input[type=submit]:hover { background:#218838; }
@media(max-width:768px) { .menun .parent-label { font-size:16px; } .child-menu li { font-size:14px; } }
</style>
</head>
<body>

<div class="permission-container">
<div class="permission-title">Edit Permissions for: <?php echo htmlspecialchars($userid); ?></div>

<div class="login-fields">
<label for="password">Password (leave blank to keep unchanged)</label>
<input type="password" id="password" name="password" placeholder="Enter new password">
</div>

<form method="post">
<ul class="menun">

<!-- Room Booking -->

<li>
    <div class="parent-label parent" data-target="rb">
        <input type="checkbox" <?php if(is_checked('hotel_new',$existing_permissions) || is_checked('hotel_new_confirm',$existing_permissions) || is_checked('hotel_new_due_payment',$existing_permissions) || is_checked('hotel_bill_list',$existing_permissions) || is_checked('customer_profile',$existing_permissions)) echo 'checked'; ?>>
        Room Booking
        <span class="toggle-icon">&#9654;</span>
    </div>
    <ul class="child-menu" id="rb">
        <li><input type="checkbox" name="hotel_new" <?php echo is_checked('hotel_new',$existing_permissions); ?>> Room Booking</li>
        <li><input type="checkbox" name="hotel_new_confirm" <?php echo is_checked('hotel_new_confirm',$existing_permissions); ?>> Room Status</li>
        <li><input type="checkbox" name="hotel_new_due_payment" <?php echo is_checked('hotel_new_due_payment',$existing_permissions); ?>> Due Payment</li>
        <li><input type="checkbox" name="hotel_bill_list" <?php echo is_checked('hotel_bill_list',$existing_permissions); ?>> All Booking List</li>
        <li><input type="checkbox" name="customer_profile" <?php echo is_checked('customer_profile',$existing_permissions); ?>> Customer Profile</li>
    </ul>
</li>

<!-- Income -->

<li>
    <div class="parent-label parent" data-target="inc">
        <input type="checkbox" <?php if(is_checked('add_income',$existing_permissions) || is_checked('income_summary',$existing_permissions) || is_checked('income_view',$existing_permissions)) echo 'checked'; ?>>
        Income
        <span class="toggle-icon">&#9654;</span>
    </div>
    <ul class="child-menu" id="inc">
        <li><input type="checkbox" name="add_income" <?php echo is_checked('add_income',$existing_permissions); ?>> Add Income</li>
        <li><input type="checkbox" name="income_summary" <?php echo is_checked('income_summary',$existing_permissions); ?>> Income Summary</li>
        <li><input type="checkbox" name="income_view" <?php echo is_checked('income_view',$existing_permissions); ?>> Income View Details</li>
    </ul>
</li>

<!-- Cost -->

<li>
    <div class="parent-label parent" data-target="cost">
        <input type="checkbox" <?php if(is_checked('add_cost',$existing_permissions) || is_checked('cost_summary',$existing_permissions) || is_checked('cost_view',$existing_permissions)) echo 'checked'; ?>>
        Cost
        <span class="toggle-icon">&#9654;</span>
    </div>
    <ul class="child-menu" id="cost">
        <li><input type="checkbox" name="add_cost" <?php echo is_checked('add_cost',$existing_permissions); ?>> Add Cost</li>
        <li><input type="checkbox" name="cost_summary" <?php echo is_checked('cost_summary',$existing_permissions); ?>> Cost Summary</li>
        <li><input type="checkbox" name="cost_view" <?php echo is_checked('cost_view',$existing_permissions); ?>> Cost View Details</li>
    </ul>
</li>

	
<!-- invest -->

<li>
    <div class="parent-label parent" data-target="invest">
        <input type="checkbox" <?php if(is_checked('add_invest',$existing_permissions)) echo 'checked'; ?>>
        Invest
        <span class="toggle-icon">&#9654;</span>
    </div>
    <ul class="child-menu" id="invest">
        <li><input type="checkbox" name="add_invest" <?php echo is_checked('add_invest',$existing_permissions); ?>> Add Invest</li>
		<li><input type="checkbox" name="invest_view" <?php echo is_checked('invest_view',$existing_permissions); ?>> Invest View</li>
    </ul>
</li>
<!-- Payable & Receivable -->

<li>
    <div class="parent-label parent" data-target="pr">
        <input type="checkbox" <?php if(is_checked('payable',$existing_permissions) || is_checked('receivable',$existing_permissions) || is_checked('payable_summary',$existing_permissions) || is_checked('payable_view',$existing_permissions) || is_checked('payable_type',$existing_permissions)) echo 'checked'; ?>>
        Payable & Receivable
        <span class="toggle-icon">&#9654;</span>
    </div>
    <ul class="child-menu" id="pr">
        <li><input type="checkbox" name="payable" <?php echo is_checked('payable',$existing_permissions); ?>> Add Payable</li>
        <li><input type="checkbox" name="receivable" <?php echo is_checked('receivable',$existing_permissions); ?>> Add Receivable</li>
        <li><input type="checkbox" name="payable_summary" <?php echo is_checked('payable_summary',$existing_permissions); ?>> P&R Summary</li>
        <li><input type="checkbox" name="payable_view" <?php echo is_checked('payable_view',$existing_permissions); ?>> P&R Details</li>
        <li><input type="checkbox" name="payable_type" <?php echo is_checked('payable_type',$existing_permissions); ?>> P&R Type</li>
    </ul>
</li>

<!-- Accounts -->

<li>
    <div class="parent-label parent" data-target="acc">
        <input type="checkbox" <?php if(is_checked('cash_book',$existing_permissions) || is_checked('profit_loss',$existing_permissions)) echo 'checked'; ?>>
        Accounts
        <span class="toggle-icon">&#9654;</span>
    </div>
    <ul class="child-menu" id="acc">
        <li><input type="checkbox" name="cash_book" <?php echo is_checked('cash_book',$existing_permissions); ?>> Cash Book</li>
        <li><input type="checkbox" name="profit_loss" <?php echo is_checked('profit_loss',$existing_permissions); ?>> Profit and Loss</li>
    </ul>
</li>

<!-- Entry -->

<li>
    <div class="parent-label parent" data-target="entry">
        <input type="checkbox" <?php if(is_checked('add_room',$existing_permissions) || is_checked('add_service',$existing_permissions) || is_checked('add_income_type',$existing_permissions) || is_checked('add_cost_type',$existing_permissions) || is_checked('add_client',$existing_permissions) || is_checked('add_bank',$existing_permissions)) echo 'checked'; ?>>
        Entry
        <span class="toggle-icon">&#9654;</span>
    </div>
    <ul class="child-menu" id="entry">
        <li><input type="checkbox" name="add_room" <?php echo is_checked('add_room',$existing_permissions); ?>> Room</li>
        <li><input type="checkbox" name="add_service" <?php echo is_checked('add_service',$existing_permissions); ?>> Additional Service</li>
        <li><input type="checkbox" name="add_income_type" <?php echo is_checked('add_income_type',$existing_permissions); ?>> Income Type</li>
        <li><input type="checkbox" name="add_cost_type" <?php echo is_checked('add_cost_type',$existing_permissions); ?>> Cost Type</li>
        <li><input type="checkbox" name="add_client" <?php echo is_checked('add_client',$existing_permissions); ?>> Customer</li>
        <li><input type="checkbox" name="add_bank" <?php echo is_checked('add_bank',$existing_permissions); ?>> Add Pay Methode</li>
    </ul>
</li>

<!-- HR -->

<li>
    <div class="parent-label parent" data-target="hr">
        <input type="checkbox" <?php if(is_checked('hr_employee',$existing_permissions) || is_checked('hr_salary',$existing_permissions) || is_checked('hr_salary_edit',$existing_permissions)) echo 'checked'; ?>>
        HR
        <span class="toggle-icon">&#9654;</span>
    </div>
    <ul class="child-menu" id="hr">
        <li><input type="checkbox" name="hr_employee" <?php echo is_checked('hr_employee',$existing_permissions); ?>> Add Employee</li>
        <li><input type="checkbox" name="hr_salary" <?php echo is_checked('hr_salary',$existing_permissions); ?>> Add Salary</li>
		<li><input type="checkbox" name="hr_salary_paid" <?php echo is_checked('hr_salary_paid',$existing_permissions); ?>> Salary Paid</li>
        <li><input type="checkbox" name="hr_salary_edit" <?php echo is_checked('hr_salary_edit',$existing_permissions); ?>> Salary Register & Edit</li>
    </ul>
</li>

<!-- Stock -->

<li>
    <div class="parent-label parent" data-target="stock">
        <input type="checkbox" <?php if(is_checked('stock_in',$existing_permissions) || is_checked('stock_out',$existing_permissions) || is_checked('bac_stock_category',$existing_permissions) || is_checked('current_stock',$existing_permissions)) echo 'checked'; ?>>
        Stock
        <span class="toggle-icon">&#9654;</span>
    </div>
    <ul class="child-menu" id="stock">
        <li><input type="checkbox" name="stock_in" <?php echo is_checked('stock_in',$existing_permissions); ?>> Stock In</li>
        <li><input type="checkbox" name="stock_out" <?php echo is_checked('stock_out',$existing_permissions); ?>> Stock Out</li>
        <li><input type="checkbox" name="bac_stock_category" <?php echo is_checked('bac_stock_category',$existing_permissions); ?>> Stock Category</li>
        <li><input type="checkbox" name="current_stock" <?php echo is_checked('current_stock',$existing_permissions); ?>> Current Stock</li>
    </ul>
</li>

<!-- User -->

<li>
    <div class="parent-label parent" data-target="user">
        <input type="checkbox" <?php if(is_checked('admin_user',$existing_permissions)) echo 'checked'; ?>>
        User
        <span class="toggle-icon">&#9654;</span>
    </div>
    <ul class="child-menu" id="user">
        <li><input type="checkbox" name="admin_user" <?php echo is_checked('admin_user',$existing_permissions); ?>> Add User</li>
		<li><input type="checkbox" name="bill_verify" <?php echo is_checked('bill_verify',$existing_permissions); ?>> Bill Verify / Cancel Booking</li>
    </ul>
</li>

</ul>

<input type="submit" value="Update Permissions">
</form>
</div>

<script>
// Toggle accordion submenu
document.querySelectorAll(".parent").forEach(function(parent) {
    parent.addEventListener("click", function(e) {
        if(e.target.tagName === "INPUT") return;
        let targetId = parent.getAttribute("data-target");
        if(!targetId) return;
        let submenu = document.getElementById(targetId);
        if(!submenu) return;
        submenu.style.display = (submenu.style.display === "block") ? "none" : "block";
        parent.classList.toggle("open");
    });
});

// Parent checkbox selects all children
document.querySelectorAll(".parent input[type=checkbox]").forEach(function(parentCheckbox) {
    parentCheckbox.addEventListener("change", function() {
        let parentDiv = this.closest(".parent");
        let targetId = parentDiv.getAttribute("data-target");
        if(!targetId) return;
        let childs = document.querySelectorAll("#" + targetId + " input[type=checkbox]");
        childs.forEach(c => c.checked = this.checked);
    });
});
</script>

</body>
</html>
